<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Provin extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        
        /*
        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            redirect('login');
        }
         * 
         */
       
        $this->load->model('db_model');
        $this->lang->load('auth', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));
        $this->load->model('auth_model');
        $this->load->library('ion_auth');
        $this->load->model('AudCon_model');
        $this->load->model('companies_model');
        $this->load->model('site');
        $this->digital_upload_path = 'assets/uploads/atas';
        $this->upload_path = 'assets/uploads/atas';
        $this->thumbs_path = 'assets/uploads/thumbs/atas';
        $this->image_types = 'gif|jpg|jpeg|png|tif';
        $this->digital_file_types = 'zip|psd|ai|rar|pdf|doc|docx|xls|xlsx|ppt|pptx|gif|jpg|jpeg|png|tif|txt';
    }

    public function index()
    {
        //////$this->sma->checkPermissions();
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
         
        $pagina = 'audcon/paginas/analises';
        
       $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function edit_analise($id)
    {
        //$this->sma->checkPermissions(false, true);

        //$this->form_validation->set_rules('email', lang("email_address"), 'is_unique[companies.email]');
         $this->form_validation->set_rules('cliente', lang("Cliente"), 'required');
         $this->form_validation->set_rules('periodo_de', lang("Período de"), 'required');
         $this->form_validation->set_rules('periodo_ate', lang("Período até"), 'required');
         
        if ($this->form_validation->run() == true) {
           
            
           /*
            * CADASTRA O CLIENTE
            */
         $regras = $this->input->post('regras');
         
            $data = array(
                'cliente' => $this->input->post('cliente'),
                'carga' => $this->input->post('carga'),
                'periodo_de' => $this->input->post('periodo_de'),
                'periodo_ate' => $this->input->post('periodo_ate'),
                'tabela' => $this->input->post('tabela'),
                'status' => 1
            );
           $id_analise = $this->input->post('id');
           
           //print_r($regras); exit;
           
           
            $this->AudCon_model->updateAnalise($id_analise, $data, $regras);
            $this->session->set_flashdata('message', lang("Análise cadastrada com sucesso!"));
            
            redirect('Provin');
          
        }else  {
           
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            
         $this->data['ativo'] = 'cliente';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
         $this->data['id'] = $id;
         $pagina = 'audcon/paginas/analises/edit_analise';
        
       $this->page_construct_novo($pagina, $meta, $this->data);
        }

     
    }
 
 function encrypt($str, $key)
        {
           
            for ($return = $str, $x = 0, $y = 0; $x < strlen($return); $x++)
            {
                $return{$x} = chr(ord($return{$x}) ^ ord($key{$y}));
                $y = ($y >= (strlen($key) - 1)) ? 0 : ++$y;
            }

            return $return;
        }

    public function processamentos($id) {
       
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
         
        
         
         $resultado_encript = str_replace('_', '=' , base64_decode($id));
         $id_analise_descript = substr($resultado_encript,0, -19);
        
         
       
         
         $this->data['ativo'] = 'analise';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
       $this->data['id'] = $id_analise_descript;
       
         $pagina = 'audcon/paginas/processamentos';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    
    public function processamentos_execucao($id) {
       
        /*
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         * 
         */
       
        // $this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            
         $resultado_encript = str_replace('_', '=' , base64_decode($id));
         $id_descript = substr($resultado_encript,0, -19);
         $chave = substr($resultado, -19);
         
         
   
         $this->data['ativo'] = 'analise';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
         $this->data['id'] = $id_descript;
       
         $pagina = 'audcon/paginas/processamentos_execucao';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    
    public function dashboardResultado($id) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            
         $id_descriptografado =  $this->encrypt($id,'ISRAEL');
         
         $this->data['ativo'] = 'analise';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
         $this->data['id'] = $id_descriptografado;
       
         $pagina = 'audcon/paginas/dashboard_resultados';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function dashboard_resultado($id) {
       
        
       
         $this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            
         $this->data['ativo'] = 'analise';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
         $this->data['id'] = $id;
       
         $pagina = 'audcon/paginas/dashboard_resultados';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function dashboard_resultado_regra($id, $regra) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
         
         $resultado_encript = str_replace('_', '=' , base64_decode($id));
         $id_descript = substr($resultado_encript,0, -19);
         
         $resultado_encript_regra = str_replace('_', '=' , base64_decode($regra));
         $regra_descript = substr($resultado_encript_regra,0, -19);
        
         
         
         $this->data['ativo'] = 'analise';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
         $this->data['id'] = $id_descript;
         $this->data['id_regra'] = $regra_descript;
         $this->data['regra_analise'] = $this->AudCon_model->getRegraProcessosAnalisesById($regra_descript, $id_descript);
         
         $pagina = 'audcon/paginas/dashboard_resultados_regra';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function dashboard_resultado_regra_teste($id, $regra) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
         
         $resultado_encript = str_replace('_', '=' , base64_decode($id));
         $id_descript = substr($resultado_encript,0, -19);
         
         $resultado_encript_regra = str_replace('_', '=' , base64_decode($regra));
         $regra_descript = substr($resultado_encript_regra,0, -19);
        
         
         
         $this->data['ativo'] = 'analise';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
         $this->data['id'] = $id_descript;
         $this->data['id_regra'] = $regra_descript;
         $this->data['regra_analise'] = $this->AudCon_model->getRegraProcessosAnalisesById($regra_descript, $id_descript);
         
         $pagina = 'audcon/paginas/dashboard_resultados_regra';
        // $this->page_construct_novo($pagina, $meta, $this->data);
         $this->load->view($this->theme . 'audcon/menu_slider_dashboard_regra');
    }
    
    public function resultado_processamentos_regra($id, $regra) {
       
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
         $resultado_encript = str_replace('_', '=' , base64_decode($id));
         $id_descript = substr($resultado_encript,0, -19);
         $chave = substr($resultado, -19);
         
         $resultado_encript_regra = str_replace('_', '=' , base64_decode($regra));
         $regra_descript = substr($resultado_encript_regra,0, -19);
         $chave_regra = substr($resultado, -19);
         
         $this->data['ativo'] = 'analise';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
         $this->data['id'] = $id_descript;
         $this->data['id_regra'] = $regra_descript;
         $this->data['regra_analise'] = $this->AudCon_model->getRegraProcessosAnalisesById($regra_descript, $id_descript);
         
         $pagina = 'audcon/paginas/resultado_analises_regra';
         $this->page_construct($pagina, $meta, $this->data);
    }
    
     public function getLogRegras()
    {
        //$this->sma->checkPermissions('index');

         if ($this->input->get('regra')) {
            $regra = $this->input->get('regra');
        } else {
            $regra = NULL;
        }
        if ($this->input->get('id_processo')) {
            $id_processo = $this->input->get('id_processo');
        } else {
            $id_processo = NULL;
        }
        if ($this->input->get('tabela')) {
            $tabela = $this->input->get('tabela');
        } else {
            $tabela = NULL;
        }
        if ($this->input->get('tabela_log')) {
            $tabela_log = $this->input->get('tabela_log');
        } else {
            $tabela_log = NULL;
        }
       
        /*
         * FILTRO
         */
      
        if ($this->input->get('competencia')) {
            $competencia = $this->input->get('competencia');
            $partes_comp = explode("/", $competencia);
            $mes = $partes_comp[0];
            $ano = $partes_comp[1];

        } else {
            $competencia = NULL;
        }
        if ($this->input->get('guias')) {
            $guias = $this->input->get('guias');
        } else {
            $guias = NULL;
        }
        if ($this->input->get('servicos')) {
            $servicos = $this->input->get('servicos');
        } else {
            $servicos = NULL;
        }
        if ($this->input->get('prestador')) {
            $prestador = $this->input->get('prestador');
        } else {
            $prestador = NULL;
        }
        if ($this->input->get('tipo_guia')) {
            $tipo_guia = $this->input->get('tipo_guia');
        } else {
            $tipo_guia = NULL;
        }
        if ($this->input->get('carater')) {
            $carater = $this->input->get('carater');
        } else {
            $carater = NULL;
        }
        if ($this->input->get('regime')) {
            $regime = $this->input->get('regime');
        } else {
            $regime = NULL;
        }
        if ($this->input->get('sexo')) {
            $sexo = $this->input->get('sexo');
        } else {
            $sexo = NULL;
        }
        
        
        $usuario = $this->session->userdata('user_id');
        //$tabela = "risk_colatina01";
       // $tabela_log = "risk_colatina01_log_inconsistencia";
        
        $this->load->library('datatables');
            $this->datatables
                ->select("$tabela_log.id as id, id_regra, CONCAT(mes,'/', ano) as competencia, guia, CONCAT(codigo_servico,'-', descricao) as servico,  $tabela_log.codigo_prestador as codigo_prestador, prestador, valor_regra, valor_cliente, $tabela_log.quantidade as quantidade, valor_inconsistencia")
                ->join($tabela, $tabela_log.'.id_base_cliente = '.$tabela.'.id', 'inner')
                ->from($tabela_log)
                //->order_by('mes', 'asc') 
               //
               ->where("processo_analise", $id_processo)
               ->where("id_regra", $regra);
                
                 
              //  $this->db->order_by('projetos.id', 'desc');
        
            if ($competencia) {
                $this->datatables->where('mes', $mes);
                $this->datatables->where('ano', $ano);
            }
            if ($guias) {
                $this->datatables->where('guia', $guias);
            }
            if ($servicos) {
                $this->datatables->where('codigo_servico', $servicos);
            }
            if ($prestador) {
                $this->datatables->where($tabela.'.codigo_prestador', $prestador);
            }
            if ($tipo_guia) {
                $this->datatables->where('tipo_guia', $tipo_guia);
            }
            if ($carater) {
                $this->datatables->where('carater_atendimento', $carater);
            }
            if ($regime) {
                $this->datatables->where('regime_atendimento', $regime);
            }
            if ($sexo) {
                $this->datatables->where('sexo_beneficiario', $sexo);
            }
            
           
       // $this->datatables->add_column("Actions", $action, "id");
        echo $this->datatables->generate();
    }
    
    
    
    public function resultado_processamentos($id) {
       
        
      
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            
         $this->data['ativo'] = 'analise';
         $this->data['layout'] ='';
         $this->data['menu'] = 'analise';
         $this->data['id'] = $id;
       
         $pagina = 'audcon/paginas/resultado_analises';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    
    
     function add_novo_processamento()
    {
        //$this->sma->checkPermissions(false, true);

        //$this->form_validation->set_rules('email', lang("email_address"), 'is_unique[companies.email]');
         $this->form_validation->set_rules('cliente', lang("Cliente"), 'required');
         $this->form_validation->set_rules('periodo_de', lang("Período de"), 'required');
         $this->form_validation->set_rules('periodo_ate', lang("Período até"), 'required');
         
         $regras = $this->input->post('regras');
        
        
        if ($this->form_validation->run('companies/add') == true) {
           
           /*
            * CADASTRA O CLIENTE
            */
         
            $data = array(
                'cliente' => $this->input->post('cliente'),
                'dt_solicitacao' => date('Y-m-d'),
                'carga' => $this->input->post('carga'),
                'periodo_de' => $this->input->post('periodo_de'),
                'periodo_ate' => $this->input->post('periodo_ate'),
                'status' => 0
                
              
            );
           
           
          //  $this->AudCon_model->addAnalise($data);
            $this->session->set_flashdata('message', lang("Análise cadastrada com sucesso!"));
            
            redirect('AudCon');
          
        }else  {
           
            $this->session->set_flashdata('error', validation_errors());
            redirect('AudCon');
        }

     
    }
     
     function add_analise()
    {
        //$this->sma->checkPermissions(false, true);

        //$this->form_validation->set_rules('email', lang("email_address"), 'is_unique[companies.email]');
         $this->form_validation->set_rules('cliente', lang("Cliente"), 'required');
         $this->form_validation->set_rules('periodo_de', lang("Período de"), 'required');
         $this->form_validation->set_rules('periodo_ate', lang("Período até"), 'required');
         
        if ($this->form_validation->run('companies/add') == true) {
           
           /*
            * CADASTRA O CLIENTE
            */
         
            $data = array(
                'cliente' => $this->input->post('cliente'),
                'dt_solicitacao' => date('Y-m-d'),
                'carga' => $this->input->post('carga'),
                'periodo_de' => $this->input->post('periodo_de'),
                'periodo_ate' => $this->input->post('periodo_ate'),
                'status' => 0
                
              
            );
           
           
            $this->AudCon_model->addAnalise($data);
            $this->session->set_flashdata('message', lang("Análise cadastrada com sucesso!"));
            
            redirect('AudCon');
          
        }else  {
           
            $this->session->set_flashdata('error', validation_errors());
            redirect('AudCon');
        }

     
    }
    
    public function modulo1($limite) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
            
         $this->data['ativo'] = 'modulo1';
         $this->data['layout'] ='sidebar-collapse';
         $this->data['menu'] = 'parametrizacao';
        if($limite){
             $this->data['limite'] = '2000';
         }else{
            $this->data['limite'] = '100';
         }
         $pagina = 'audcon/paginas/parametros/modulo1';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function modulo2($limite) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
            
         $this->data['ativo'] = 'modulo2';
         $this->data['layout'] ='sidebar-collapse';
         $this->data['menu'] = 'parametrizacao';
        if($limite){
             $this->data['limite'] = '';
         }else{
            $this->data['limite'] = '100';
         }
         $pagina = 'audcon/paginas/parametros/modulo2';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function modulo3($limite) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
        
            
         $this->data['ativo'] = 'modulo3';
         $this->data['layout'] ='sidebar-collapse';
         $this->data['menu'] = 'parametrizacao';
         if($limite){
             $this->data['limite'] = '';
         }else{
            $this->data['limite'] = '100';
         }
         $pagina = 'audcon/paginas/parametros/modulo3';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function modulo4($limite) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
        
            
         $this->data['ativo'] = 'modulo4';
         $this->data['layout'] ='sidebar-collapse';
         $this->data['menu'] = 'parametrizacao';
         if($limite){
             $this->data['limite'] = '';
         }else{
            $this->data['limite'] = '100';
         }
         $pagina = 'audcon/paginas/parametros/modulo4';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }

    public function regras($limite) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
            
         $this->data['ativo'] = 'regras';
         $this->data['layout'] ='sidebar-collapse';
         $this->data['menu'] = 'cadastros';
        if($limite){
             $this->data['limite'] = '';
         }else{
            $this->data['limite'] = '100';
         }
         $pagina = 'audcon/paginas/cadastro/regras/regras';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    function add_condicao()
    {
        //$this->sma->checkPermissions(false, true);

        $id = $this->input->post('id_regra');
        $this->form_validation->set_rules('cliente', lang("Valor Cliente"), 'required');
        $this->form_validation->set_rules('valor2', lang("E-Valor Base"), 'required');
         
         
        if ($this->form_validation->run('companies/add') == true) {
           
             $data = array(
                'valor_cliente' => $this->input->post('cliente'),
                'condicao' => $this->input->post('condicao'),
                'valor_base' => $this->input->post('valor2'),
                'resultado' => $this->input->post('resultado'),
                'id_regra' => $this->input->post('id_regra')
            );
            
             $this->AudCon_model->addCondicaoRegra($data);
           //
            
          
            
            redirect('AudCon/editar_regra/'.$id);
          
        } elseif ($this->input->post('add_customer')) {
           
            $this->session->set_flashdata('error', validation_errors());
            redirect('AudCon/editar_regra/'.$id);
        }

     
    }
    
    function add_valor_condicao_Cadastro()
    {
        //$this->sma->checkPermissions(false, true);

        $this->form_validation->set_rules('valor', lang("Valor"), 'required');
        $this->form_validation->set_rules('descricao', lang("Descrição"), 'required');
         
         
        if ($this->form_validation->run('companies/add') == true) {
           
            $analises_total = $this->AudCon_model->getContOpcoesValoresRegra();
            $posicao = $analises_total->quantidade;
           
            $data = array(
                'valor' => $this->input->post('valor'),
                'descricao' => $this->input->post('descricao'),
                'posicao' => $posicao
            );
             $this->AudCon_model->addOpcaoValorRegra($data);
            
            redirect('AudCon/valoresRegras/');
          
        } elseif ($this->input->post('add_customer')) {
           
            $this->session->set_flashdata('error', validation_errors());
            redirect('AudCon/valoresRegras/');
        }

     
    }
    
    function add_valor_condicao()
    {
        //$this->sma->checkPermissions(false, true);

        $id = $this->input->post('id_regra');
        
        $this->form_validation->set_rules('valor', lang("Valor"), 'required');
        $this->form_validation->set_rules('descricao', lang("Descrição"), 'required');
         
         
        if ($this->form_validation->run('companies/add') == true) {
           $analises_total = $this->AudCon_model->getContOpcoesValoresRegra();
            $posicao = $analises_total->quantidade;
            $data = array(
                'valor' => $this->input->post('valor'),
                'descricao' => $this->input->post('descricao'),
                'posicao' => $posicao
            );
             $this->AudCon_model->addOpcaoValorRegra($data);
            
            redirect('AudCon/editar_regra/'.$id);
          
        } elseif ($this->input->post('add_customer')) {
           
            $this->session->set_flashdata('error', validation_errors());
            redirect('AudCon/editar_regra/'.$id);
        }

     
    }
    
    public function add_nova_regra() {
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
        
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        //$this->form_validation->set_rules('email', lang("email_address"), 'is_unique[companies.email]');
         $this->form_validation->set_rules('numero', lang("Empresa"), 'required');
         $this->form_validation->set_rules('descricao', lang("E-mail"), 'required');
         
         
        if ($this->form_validation->run('companies/add') == true) {
           
             $data = array(
                'sessao' => $this->input->post('numero'),
                'descricao' => $this->input->post('descricao'),
                'observacao' => $this->input->post('observacao'),
                'estrutura_cliente' => $this->input->post('cliente')
            );
            //print_r($data);exit;
            $this->AudCon_model->addNovaRegra($data);
            
            $this->session->set_flashdata('message', lang("Cadastro efetuado com sucesso!"));
            redirect('AudCon/regras');
             
          } else{
           
            $this->session->set_flashdata('error', validation_errors());
            
            $this->data['ativo'] = 'regras';
            $this->data['layout'] ='';
            $this->data['menu'] = 'regras';
            $this->data['id'] = $id;
       
         $pagina = 'audcon/paginas/cadastro/regras/editar_regra';
         $this->page_construct_novo($pagina, $meta, $this->data);
        }
         
         
        
    }
    
    public function editar_regra($id) {
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
        
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        //$this->form_validation->set_rules('email', lang("email_address"), 'is_unique[companies.email]');
         $this->form_validation->set_rules('numero', lang("Empresa"), 'required');
         $this->form_validation->set_rules('descricao', lang("E-mail"), 'required');
         
         
        if ($this->form_validation->run('companies/add') == true) {
           
             $data = array(
                'sessao' => $this->input->post('numero'),
                'descricao' => $this->input->post('descricao'),
                'observacao' => $this->input->post('observacao'),
                'estrutura_cliente' => $this->input->post('cliente')
            );
             $id = $this->input->post('id');
            
             $this->AudCon_model->updateRegra($id, $data);
            
             
             $this->session->set_flashdata('message', lang("Cadastro Atualizado com Sucesso! "));
            
            $this->data['ativo'] = 'regras';
            $this->data['layout'] ='';
            $this->data['menu'] = 'regras';
            $this->data['id'] = $id;
       
         $pagina = 'audcon/paginas/cadastro/regras/editar_regra';
         $this->page_construct_novo($pagina, $meta, $this->data);
             
          } else{
           
            $this->session->set_flashdata('error', validation_errors());
            
            $this->data['ativo'] = 'regras';
            $this->data['layout'] ='';
            $this->data['menu'] = 'regras';
            $this->data['id'] = $id;
       
         $pagina = 'audcon/paginas/cadastro/regras/editar_regra';
         $this->page_construct_novo($pagina, $meta, $this->data);
        }
         
         
        
    }
    
    function inativa_regra($id = NULL)
    {
         $data = array(
                
                'status' => 0
              
            );
            
            $id_cliente = $id;
           //print_r($data);exit;
            $cid = $this->AudCon_model->updateRegra($id_cliente, $data);
            $this->session->set_flashdata('message', lang("Cadastro Inativado com Sucesso! "));
            
            redirect('AudCon/regras');
           
         
    }
    
    public function clientes($limite) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
            
         $this->data['ativo'] = 'cliente';
         $this->data['layout'] ='';
         $this->data['menu'] = 'cadastros';
        if($limite){
             $this->data['limite'] = '';
         }else{
            $this->data['limite'] = '100';
         }
         $pagina = 'audcon/paginas/cadastro/cliente/cliente';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    function add_cliente()
    {
        //$this->sma->checkPermissions(false, true);

        //$this->form_validation->set_rules('email', lang("email_address"), 'is_unique[companies.email]');
         $this->form_validation->set_rules('company', lang("Empresa"), 'required');
         $this->form_validation->set_rules('email', lang("E-mail"), 'required');
         
         
        if ($this->form_validation->run('companies/add') == true) {
           
           /*
            * CADASTRA O CLIENTE
            */
         
            $data = array(
                'company' => $this->input->post('company'),
                'name' => $this->input->post('name'),
                'email' => $this->input->post('email'),
                'group_id' => '3',
                'group_name' => 'customer',
                'vat_no' => $this->input->post('vat_no'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
                'state' => $this->input->post('state'),
                'phone' => $this->input->post('phone'),
                'postal_code' => $this->input->post('postal_code'),
                'audcon' => 1,
                'status' => 1
              
            );
           $cid = $this->companies_model->addCompany($data);
            
            
           
           /*
             * CADASTRA O USUÁRIO DO CLIENTE
             */
            $active = 1;
            $notify = 0;
           
            $email = strtolower($this->input->post('email'));
            $password = 'Acesso*2018';
            $additional_data = array(
                'first_name' => $this->input->post('company'),
                //'last_name' => $this->input->post('last_name'),
                'phone' => $this->input->post('phone'),
                //'gender' => $this->input->post('gender'),
                'company_id' => $cid,
               // 'company' => $company->company,
                'group_id' => 5
            );
            $this->load->library('ion_auth');
            $id_user =  $this->ion_auth->register($email, $password, $email, $additional_data, $active, $notify);
          
            /*
             * ADICIONA O USUÁRIO AO SISTEMA QUE ELE TERÁ ACESSO
             */
            $data_user_sis = array(
                'usuario' => $id_user,
                'sistema' => 3
            );
            $this->AudCon_model->addUserSistema($data_user_sis);
           
            $this->session->set_flashdata('message', lang("customer_added"));
            
            redirect('AudCon/clientes');
          
        } elseif ($this->input->post('add_customer')) {
           
            $this->session->set_flashdata('error', validation_errors());
            redirect('AudCon/clientes');
        }

     
    }

    function edit_cliente($id = NULL)
    {
        //$this->sma->checkPermissions(false, true);
        $this->form_validation->set_rules('company', lang("company"), 'required');
         $this->form_validation->set_rules('email', lang("name"), 'required');
        

       // $company_details = $this->companies_model->getCompanyByID($id);
       // if ($this->input->post('email') != $company_details->email) {
        //    $this->form_validation->set_rules('code', lang("email_address"), 'is_unique[companies.email]');
       // }

        if ($this->form_validation->run('companies/add') == true) {
            
            
            /*
            * CADASTRA O CLIENTE
            */
         
            $data = array(
                'company' => $this->input->post('company'),
                'name' => $this->input->post('name'),
                'email' => $this->input->post('email'),
                'group_id' => '3',
                'group_name' => 'customer',
                'vat_no' => $this->input->post('vat_no'),
                'address' => $this->input->post('address'),
                'city' => $this->input->post('city'),
                'state' => $this->input->post('state'),
                'phone' => $this->input->post('phone'),
                'postal_code' => $this->input->post('postal_code')
              
            );
            
            $additional_user = array(
                'first_name' => $this->input->post('company'),
                'phone' => $this->input->post('phone'),
                'email' => $this->input->post('email'),
                'username' => $this->input->post('email')
            );
            
            $id = $this->input->post('id');
           
            $cid = $this->AudCon_model->updateCliente($id, $data, $additional_user);
            
            $this->session->set_flashdata('message', lang("Cadastro Alterado com Sucesso! "));
            
            redirect('AudCon/clientes');
           
        } else {
            
        
            $this->data['ativo'] = 'cliente';
            $this->data['layout'] = '';
            $this->data['menu'] = 'cadastros';
            if ($limite) {
                $this->data['limite'] = '';
            } else {
                $this->data['limite'] = '100';
            }
            $this->data['id'] = $id;

            $pagina = 'audcon/paginas/cadastro/cliente/edit_cliente';
         $this->page_construct_novo($pagina, $meta, $this->data);
        }
    }
    
    function inativa_cliente($id = NULL)
    {
       
            /*
            * CADASTRA O CLIENTE
            */
         
            $data = array(
                
                'status' => 0
              
            );
            
            $additional_user = array(
                'active' => 0
            );
            
            $id_cliente = $id;
           
            $cid = $this->AudCon_model->updateCliente($id_cliente, $data, $additional_user);
            
            $this->session->set_flashdata('message', lang("Cadastro Inativado com Sucesso! "));
            
            redirect('AudCon/clientes');
           
         
    }
    
    function ativa_cliente($id = NULL)
    {
       
            /*
            * CADASTRA O CLIENTE
            */
         
            $data = array(
                
                'status' => 1
              
            );
            
            $additional_user = array(
                'active' => 1
            );
            
            $id_cliente = $id;
           
            $cid = $this->AudCon_model->updateCliente($id_cliente, $data, $additional_user);
            
            $this->session->set_flashdata('message', lang("Cadastro Ativado com Sucesso! "));
            
            redirect('AudCon/clientes');
           
         
    }
  
    public function estrutura_cliente($limite) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
            
         $this->data['ativo'] = 'estrutura';
         $this->data['layout'] ='';
         $this->data['menu'] = 'cadastros';
        if($limite){
             $this->data['limite'] = '';
         }else{
            $this->data['limite'] = '100';
         }
         $pagina = 'audcon/paginas/cadastro/estrutura_cliente/estrutura';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public  function add_estrutura_cliente()
    {
        //$this->sma->checkPermissions(false, true);

        //$this->form_validation->set_rules('email', lang("email_address"), 'is_unique[companies.email]');
         $this->form_validation->set_rules('campo', lang("Nome Campo"), 'required');
         $this->form_validation->set_rules('valores', lang("Valores"), 'required');
         
         
        if ($this->form_validation->run('estrutura/add') == true) {
           
           $analises_total = $this->AudCon_model->getContEstrutura();
            $posicao = $analises_total->quantidade;
            
             $data = array(
                'nome' => $this->input->post('campo'),
                'valores' => $this->input->post('valores'),
                 'posicao' => $posicao
                );
     
            $cid = $this->AudCon_model->addEstrutura_cliente($data);
            $this->session->set_flashdata('message', lang("Cadastrado com Sucesso"));
            
            redirect('AudCon/estrutura_cliente');
          
        } else {
           
            $this->session->set_flashdata('error', validation_errors());
            redirect('AudCon/estrutura_cliente');
        }

     
    }

    public function delete_estrutura($id = NULL)
    {    
            $id_cliente = $id;
           
            $cid = $this->AudCon_model->deleteEstrutura($id);
            
            $this->session->set_flashdata('message', lang("Cadastro Deletado com Sucesso! "));
            
            redirect('AudCon/estrutura_cliente');
           
         
    }
    
    
    public function delete_condicao($id, $regra)
    {    
        
            $this->AudCon_model->deleteCondicaoRegra($id);
            
            $this->session->set_flashdata('message', lang("Cadastro Deletado com Sucesso! "));
            redirect('AudCon/editar_regra/'.$regra);
           
         
    }
    
    public function valoresRegras($limite) {
       
        
        if ($this->Settings->version == '2.3') {
            $this->session->set_flashdata('warning', 'Please complete your update by synchronizing your database.');
            redirect('sync');
        }
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        
            
         $this->data['ativo'] = 'valores';
         $this->data['layout'] ='';
         $this->data['menu'] = 'cadastros';
        if($limite){
             $this->data['limite'] = '';
         }else{
            $this->data['limite'] = '100';
         }
         $pagina = 'audcon/paginas/cadastro/opcaoValor/valores';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function delete_valores_regra($id = NULL)
    {    
            $id_cliente = $id;
           
            $cid = $this->AudCon_model->deleteOpcaoValor($id);
            
            $this->session->set_flashdata('message', lang("Cadastro Deletado com Sucesso! "));
            
            redirect('AudCon/valoresRegras');
           
         
    }
    
    public function processa_regra_23($id) {
      
          // CONSTA NO ROL    
        if($id == 23){
           
             //EXECULTA A CONDIÇÃO 1 DA REGRA E != U
            $dados_regra_23 = $this->AudCon_model->getRegra23();
            $this->AudCon_model->atualizaStatusInicioProcessamento(28,23);
            $cont_anamento1 = 0;
            foreach ($dados_regra_23 as $dados) {
                $id_base_cliente =  $dados->id;
                $guia =  $dados->guia;
                $codigo_prestador =  $dados->codigo_prestador;
                $valor_procedimento =  $dados->valor_procedimento;
                $quantidade =  $dados->quantidade;
                $rol =  $dados->rol;
               
                $valor_total_pagar = $valor_procedimento * $quantidade;
                
                $data = array(
                'processo_analise' => 28,
                'id_base_cliente' => $id_base_cliente,
                'valor_cliente' => 'SIM',
                'valor_regra' => 'NÃO',
                'valor_inconsistencia' => $valor_total_pagar,
                'id_regra' =>23,
                'quantidade' => $quantidade,
                'codigo_prestador' => $codigo_prestador
                );
           PRINT_R($data); EXIT;
              $this->AudCon_model->addLogInconsistencia('risk_unimed_fortaleza_log_inconsistencia',$data, 28,23, $cont_anamento1++ );
                
            }
             $this->AudCon_model->atualizaTempoFimProcessamento(28,23);
            
        }
        echo 'Finalizou o Processamento'; exit;
         
         $pagina = 'audcon/paginas/processamentos';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function processa_regra_47($id) {
      
          // CONSTA NO ROL    
        if($id == 47){
           
             //EXECULTA A CONDIÇÃO 1 DA REGRA E != U
            $dados_regra_23 = $this->AudCon_model->getRegra47();
            $this->AudCon_model->atualizaStatusInicioProcessamento(28,47);
            $cont_anamento1 = 0;
            foreach ($dados_regra_23 as $dados) {
                $id_base_cliente =  $dados->id;
                echo 'aqui'. $id_base_cliente; exit;
                $guia =  $dados->guia;
                $codigo_prestador =  $dados->codigo_prestador;
                $valor_procedimento =  $dados->valor_procedimento;
                $quantidade =  $dados->quantidade;
                $rol =  $dados->rol;
               
                $valor_total_pagar = $valor_procedimento * $quantidade;
                
                $data = array(
                'processo_analise' => 28,
                'id_base_cliente' => $id_base_cliente,
                'valor_cliente' => 'SIM',
                'valor_regra' => 'NÃO',
                'valor_inconsistencia' => $valor_total_pagar,
                'id_regra' =>23,
                'quantidade' => $quantidade,
                'codigo_prestador' => $codigo_prestador
                );
           PRINT_R($data); EXIT;
              $this->AudCon_model->addLogInconsistencia('risk_unimed_fortaleza_log_inconsistencia',$data, 28,23, $cont_anamento1++ );
                
            }
             $this->AudCon_model->atualizaTempoFimProcessamento(28,23);
            
        }
        echo 'Finalizou o Processamento'; exit;
         
         $pagina = 'audcon/paginas/processamentos';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    public function processa_regra($id) {
       
         //$this->sma->checkPermissions();
         $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
         
        if ($id == 34){
            /*
            //EXECULTA A CONDIÇÃO 1 DA REGRA E != U
            $dados_regra_34 = $this->AudCon_model->getRegra34_1(28);
            $cont_anamento1 = 0;
            foreach ($dados_regra_34 as $dados) {
                $id_base_cliente =  $dados->id;
                $guia =  $dados->guia;
                $codigo_prestador =  $dados->codigo_prestador;
                $valor_procedimento =  $dados->valor_procedimento;
                $quantidade =  $dados->quantidade;
                $carater_atendimento =  $dados->carater_atendimento;
                $tipo_procedimento =  $dados->tipo_procedimento;
                $valor_total_pagar = $valor_procedimento * $quantidade;
                
                
                $data = array(
                'processo_analise' => 28,
                'id_base_cliente' => $id_base_cliente,
                'valor_cliente' => 'E',
                'valor_regra' => 'U',
                'valor_inconsistencia' => $valor_total_pagar,
                'id_regra' => 94,
                'quantidade' => $quantidade,
                'codigo_prestador' => $codigo_prestador
                );
           
              $this->AudCon_model->addLogInconsistencia('risk_unimed_fortaleza_log_inconsistencia',$data, 28,94, $cont_anamento1++ );
                
            }
            */
            //EXECULTA A CONDIÇÃO 2 DA REGRA U != E
            $dados_regra_34_2 = $this->AudCon_model->getRegra34_2();
            $this->AudCon_model->atualizaStatusInicioProcessamento(28,94);
            $cont_anamento2 = 0;
            foreach ($dados_regra_34_2 as $dados2) {
                $id_base_cliente =  $dados2->id;
                $guia =  $dados2->guia;
                $codigo_prestador =  $dados2->codigo_prestador;
                $valor_procedimento =  $dados2->valor_procedimento;
                $quantidade =  $dados2->quantidade;
                $carater_atendimento =  $dados2->carater_atendimento;
                $tipo_procedimento =  $dados2->tipo_procedimento;
                $valor_total_pagar = $valor_procedimento * $quantidade;
                
                
                $data = array(
                'processo_analise' => 28,
                'id_base_cliente' => $id_base_cliente,
                'valor_cliente' => 'U',
                'valor_regra' => 'E',
                'valor_inconsistencia' => $valor_total_pagar,
                'id_regra' => 94,
                'quantidade' => $quantidade,
                'codigo_prestador' => $codigo_prestador
                );
           
              $this->AudCon_model->addLogInconsistencia('risk_unimed_fortaleza_log_inconsistencia',$data, 28,94, $cont_anamento2++ );
                
            }
            $this->AudCon_model->atualizaTempoFimProcessamento(28,94);
        }else
            
        // CONSTA NO ROL    
        if($id == 23){
            
             //EXECULTA A CONDIÇÃO 1 DA REGRA E != U
            $dados_regra_23 = $this->AudCon_model->getRegra23();
            $this->AudCon_model->atualizaStatusInicioProcessamento(28,23);
            $cont_anamento1 = 0;
            foreach ($dados_regra_23 as $dados) {
                $id_base_cliente =  $dados->id;
                echo $id_base_cliente; exit;
                $guia =  $dados->guia;
                $codigo_prestador =  $dados->codigo_prestador;
                $valor_procedimento =  $dados->valor_procedimento;
                $quantidade =  $dados->quantidade;
                $rol =  $dados->rol;
               
                $valor_total_pagar = $valor_procedimento * $quantidade;
                
                $data = array(
                'processo_analise' => 28,
                'id_base_cliente' => $id_base_cliente,
                'valor_cliente' => 'SIM',
                'valor_regra' => 'NÃO',
                'valor_inconsistencia' => $valor_total_pagar,
                'id_regra' =>23,
                'quantidade' => $quantidade,
                'codigo_prestador' => $codigo_prestador
                );
           
              $this->AudCon_model->addLogInconsistencia('risk_unimed_fortaleza_log_inconsistencia',$data, 28,23, $cont_anamento1++ );
                
            }
             $this->AudCon_model->atualizaTempoFimProcessamento(28,23);
            
        }else
            
        //51 - QUANTIDADE
        if($id == 51){
             
            $dados_regra_51 = $this->AudCon_model->getRegra51(51);
            $this->AudCon_model->atualizaStatusInicioProcessamento(28,51);
            $cont_anamento1 = 0;
            foreach ($dados_regra_51 as $dados) {
                $id_base_cliente =  $dados->id;
                $guia =  $dados->guia;
                $codigo_prestador =  $dados->codigo_prestador;
                $valor_procedimento =  $dados->valor_procedimento;
                $quantidade =  $dados->quantidade_cliente;
                $quantidade_base =  $dados->quantidade_base;
                
                $valor_total_pagar = $valor_procedimento * $quantidade;
                
                $data = array(
                'processo_analise' => 28,
                'id_base_cliente' => $id_base_cliente,
                'valor_cliente' => $quantidade,
                'valor_regra' => $quantidade_base,
                'valor_inconsistencia' => $valor_total_pagar,
                'id_regra' =>51,
                'quantidade' => $quantidade,
                'codigo_prestador' => $codigo_prestador
                );
           
              $this->AudCon_model->addLogInconsistencia('risk_unimed_fortaleza_log_inconsistencia',$data, 28,51, $cont_anamento1++ );
                
            }
             $this->AudCon_model->atualizaTempoFimProcessamento(28,51);
            
        }else
        
         // CIRURGICO   
        if($id == 38){
            
             //EXECULTA A CONDIÇÃO CIRURGICO
            $dados_regra_38 = $this->AudCon_model->getRegra38_2();
          
           // $this->AudCon_model->atualizaStatusInicioProcessamento(28,38);
            $cont_anamento1 = 0;
            foreach ($dados_regra_38 as $dados) {
               
                $id_base_cliente =  $dados->id;
                $codigo_prestador =  $dados->codigo_prestador;
                $valor_procedimento =  $dados->valor_procedimento;
                $quantidade =  $dados->quantidade;
                $codigo_servico =  $dados->codigo_servico;
                
                $valor_total_pagar = $valor_procedimento * $quantidade;
               
                
                //$verifica_base = $this->AudCon_model->getBancoRegraByCodigoservico($codigo_servico);
                //$cirurgico = $verifica_base->cirurgico;
                
                 
                    $data = array(
                    'processo_analise' => 28,
                    'id_base_cliente' => $id_base_cliente,
                    'valor_cliente' => 'NÃO',
                    'valor_regra' => 'SIM',
                    'valor_inconsistencia' => $valor_total_pagar,
                    'id_regra' => 38,
                    'quantidade' => $quantidade,
                    'codigo_prestador' => $codigo_prestador
                    );
                  
                    $this->AudCon_model->addLogInconsistencia('risk_unimed_fortaleza_log_inconsistencia',$data, 28,38, $cont_anamento1++ );
               
                
                
            }
             $this->AudCon_model->atualizaTempoFimProcessamento(28,38);
            
        }    
        
        
        
        
       echo 'Finalizou o Processamento'; exit;
         
         $pagina = 'audcon/paginas/processamentos';
         $this->page_construct_novo($pagina, $meta, $this->data);
    }
    
    
    
}
